<?php

class ControllerExtensionPaymentWorldnetPayments extends Controller {
	public function index() {

		$this->load->language('extension/payment/worldnetpayments');
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
		
		$data['test'] = $this->config->get($this->language->get('text_terminaltest'));
		$data['action'] = ($data['test'] == '1') ? 'https://testpayments.worldnettps.com/merchant/paymentpage' : 'https://payments.worldnettps.com/merchant/paymentpage';
		
		
		$currency_terminal1 = $this->config->get($this->language->get('text_terminalcur').'1');
		$currency_terminal2 = $this->config->get($this->language->get('text_terminalcur').'2');
		$currency_terminal3 = $this->config->get($this->language->get('text_terminalcur').'3');
		
		$data['terminalid'] = '';
		$data['terminalcur'] = '';
		$secret = '';
		if($order_info['currency_code'] == $currency_terminal1 || $currency_terminal1 == 'MC') {
			$data['terminalid'] = $this->config->get($this->language->get('text_terminalid').'1');
			$secret = $this->config->get($this->language->get('text_terminalsecret').'1');
			$data['terminalcur'] = $currency_terminal1;
		} elseif ($order_info['currency_code'] == $currency_terminal2 || $currency_terminal2 == 'MC') {
			$data['terminalid'] = $this->config->get($this->language->get('text_terminalid').'2');
			$secret = $this->config->get($this->language->get('text_terminalsecret').'2');
			$data['terminalcur'] = $currency_terminal2;
		} elseif ($order_info['currency_code'] == $currency_terminal3 || $currency_terminal3 == 'MC') {
			$data['terminalid'] = $this->config->get($this->language->get('text_terminalid').'3');
			$secret = $this->config->get($this->language->get('text_terminalsecret').'3');
			$data['terminalcur'] = $currency_terminal3;
		} else {
			$data['error'] = $this->language->get('error_nocurrency');
		}
		
		
		$data['currency'] = $order_info['currency_code'];

		$data['date_time']   = date('d-m-Y:H:i:s:000');
		$data['order_id']    = $order_info['order_id'];
		$data['name']        = $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'];
		$data['description'] = $this->config->get('config_name') . ' - #' . $order_info['order_id'];
		$data['amount']      = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], FALSE);
		
		$data['address1'] = $order_info['payment_address_1'] . (($order_info['payment_address_2']) ? ', ' . $order_info['payment_address_2'] : '');
		$data['address2'] = $order_info['payment_city'] . ', ' . $order_info['payment_zone'];
		
		$data['postcode'] = $order_info['payment_postcode'];
		$data['country'] = $order_info['payment_iso_code_2'];
		$data['telephone'] = $order_info['telephone'];
		$data['email'] = ($this->config->get($this->language->get('text_send_receipt'))) == '1' ? $order_info['email'] : '';

		$data['receipt_page_URL'] = $this->url->link('extension/payment/worldnetpayments/callback');
		$data['validation_URL'] = $this->url->link('extension/payment/worldnetpayments/validate');

		$data['hash'] = md5($data['terminalid'] . $data['order_id'] . (($data['terminalcur'] == 'MC') ? $order_info['currency_code'] : '' ) . $data['amount'] . $data['date_time'] . $data['receipt_page_URL'] . $data['validation_URL'] . $secret);
		
		return $this->load->view('extension/payment/worldnetpayments', $data);
	}
	
	public function callback() {
	
        $this->load->language('extension/payment/worldnetpayments');
        
        $this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        
		if (isset($this->request->get['RESPONSECODE']) && isset($this->request->get['TERMINALID']) && isset($this->request->get['HASH'])) {
			
			switch($this->request->get['TERMINALID']) {
				case $this->config->get($this->language->get('text_terminalid').'3') :
					$data['currency'] = $this->config->get($this->language->get('text_terminalcur').'3');
					$secret = $this->config->get($this->language->get('text_terminalsecret').'3');
					break;
				case $this->config->get($this->language->get('text_terminalid').'2') :
					$data['currency'] = $this->config->get($this->language->get('text_terminalcur').'2');
					$secret = $this->config->get($this->language->get('text_terminalsecret').'2');
					break;
				case $this->config->get($this->language->get('text_terminalid').'1') :
					$data['currency'] = $this->config->get($this->language->get('text_terminalcur').'1');
					$secret = $this->config->get($this->language->get('text_terminalsecret').'1');
					break;
			}
			
			$data['terminalid'] = $this->request->get['TERMINALID'];
			$strHash = $this->request->get['TERMINALID'] . $this->request->get['ORDERID'] . (($data['currency'] == 'MC') ? $order_info['currency_code'] : '' ) . $this->request->get['AMOUNT'] . $this->request->get['DATETIME'] . $this->request->get['RESPONSECODE'] . $this->request->get['RESPONSETEXT'] . $secret;
			
			if ($this->request->get['HASH'] == md5($strHash)) {
				if ($this->request->get['RESPONSECODE']=='A' || $this->request->get['RESPONSECODE']=='E') {
					// Transaction Approved
		  			$this->response->redirect($this->url->link('checkout/success', '', 'SSL'));
				} else {
					// Transaction Declined
					$this->session->data['error'] = 'Transaction Declined. Bank Response: '.$this->request->get['RESPONSETEXT'];
		  			$this->response->redirect($this->url->link('checkout/checkout', '', 'SSL'));
				}
			} else {
				// Response Hash validation failed
				$this->session->data['error'] = 'ERROR! Response Hash Validation Failed. Please contact us ASAP with Order ID '.$this->request->get['ORDERID'].' to ensure that you will not be charged.';
		  		$this->response->redirect($this->url->link('checkout/checkout', '', 'SSL'));
			}
		}
	}

	public function validate() {
		$this->load->language('extension/payment/worldnetpayments');
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->request->post['ORDERID']);
		
		$message = '';
		if (isset($this->request->post['RESPONSECODE']) && isset($this->request->post['TERMINALID']) && isset($this->request->post['HASH'])) {
			switch($this->request->post['TERMINALID']) {
				case $this->config->get($this->language->get('text_terminalid').'3') :
					$data['currency'] =$this->config->get($this->language->get('text_terminalcur').'3');
					$secret = $this->config->get($this->language->get('text_terminalsecret').'3');
					break;
				case $this->config->get($this->language->get('text_terminalid').'2') :
					$data['currency'] =$this->config->get($this->language->get('text_terminalcur').'2');
					$secret = $this->config->get($this->language->get('text_terminalsecret').'2');
					break;
				case $this->config->get($this->language->get('text_terminalid').'1') :
					$data['currency'] =$this->config->get($this->language->get('text_terminalcur').'1');
					$secret = $this->config->get($this->language->get('text_terminalsecret').'1');
					break;
			}
			
			$data['terminalid'] = $this->request->post['TERMINALID'];
			$strHash = $this->request->post['TERMINALID'] . $this->request->post['ORDERID'] . (($data['currency'] == 'MC') ? $order_info['currency_code'] : '' ) . $this->request->post['AMOUNT'] . $this->request->post['DATETIME'] . $this->request->post['RESPONSECODE'] . $this->request->post['RESPONSETEXT'] . $secret;
			
			if ($this->request->post['HASH'] == md5($strHash)) {
				if ($this->request->post['RESPONSECODE'] == 'A' || $this->request->post['RESPONSECODE'] == 'E') {
					if (isset($this->request->post['UNIQUEREF'])) $message .= 'Unique Reference: ' . $this->request->post['UNIQUEREF'] . "\n";
					if (isset($this->request->post['RESPONSETEXT'])) $message .= 'Response Message: ' . $this->request->post['RESPONSETEXT'] . "\n";
					if (isset($this->request->post['APPROVALCODE'])) $message .= 'Bank Approval Code: ' . $this->request->post['APPROVALCODE'] . "\n";
					if (isset($this->request->post['AVSRESPONSE'])) $message .= 'AVS Response: ' . $this->request->post['AVSRESPONSE'] . "\n";
					if (isset($this->request->post['CVVRESPONSE'])) $message .= 'CVV Response: ' . $this->request->post['CVVRESPONSE'] . "\n";
					if (isset($this->request->post['DATETIME'])) $message .= 'Server date & Time: ' . $this->request->post['DATETIME'];
					
					$this->model_checkout_order->addOrderHistory($this->request->post['ORDERID'], $this->config->get($this->language->get('text_status_success')), $message, FALSE);
		  			die("OK");
				} else {
					if (isset($this->request->post['RESPONSETEXT'])) $message = 'Response Message: ' . $this->request->post['RESPONSETEXT'];
					$this->model_checkout_order->addOrderHistory($this->request->post['ORDERID'], $this->config->get($this->language->get('text_status_declined')), $message, FALSE);
					die("OK");
				}
			} else {
				$message = "Response hash validation failed. Expected" . md5($strHash) . ", received: " . $this->request->post['HASH'] . ".";
				$this->model_checkout_order->addOrderHistory($this->request->post['ORDERID'], $this->config->get($this->language->get('text_status_failed')), $message, FALSE);
				die("Response hash validation failed.");
			}
		} else {
			$message = "Not all of RESPONSECODE, TERMINALID and HASH exist in validation request.";
			$this->model_checkout_order->addOrderHistory($this->request->post['ORDERID'], $this->config->get($this->language->get('text_status_failed')), $message, FALSE);
			die("Not all of RESPONSECODE, TERMINALID and HASH exist in validation request.");
		}
	}
}
?>
